/*
 * Decompiled with CFR 0.152.
 */
package M2J;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UDF {
    static String findFirstMatch(String pattern, String searchString) {
        Pattern p = Pattern.compile((pattern = pattern.replaceAll("#", "\\\\d")).trim());
        Matcher m = p.matcher(searchString.trim());
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    static String findLastMatch(String pattern, String searchString) {
        pattern = pattern.replaceAll("#", "\\\\d");
        Pattern p = Pattern.compile(pattern.trim());
        Matcher m = p.matcher(searchString.trim());
        String result = "";
        while (m.find()) {
            result = m.group();
        }
        return result;
    }

    static String listRunningProcesses() {
        String processes = "";
        try {
            String line;
            Process p = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().equals("")) continue;
                line = line.substring(1);
                processes = processes + line.substring(0, line.indexOf("\"")) + ",";
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return processes;
    }

    public static Boolean isCheckDigitValid(String iban) {
        if (null == iban) {
            return false;
        }
        if ((iban = iban.replaceAll(" ", "")).length() < 4) {
            return false;
        }
        int validIBANLength = UDF.getValidIBANLength(iban);
        if (iban.length() != validIBANLength) {
            return false;
        }
        BigInteger numericIBAN = UDF.getNumericIBAN(iban, false);
        int checkDigit = numericIBAN.mod(new BigInteger("97")).intValue();
        return checkDigit == 1;
    }

    public static String getIP() {
        String ipAddr;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ipAddr = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            ipAddr = "IP Address could not be determined: " + e.getMessage();
        }
        return ipAddr;
    }

    public static String getHostName() {
        String hostName;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "Hostname could not be determined: " + e.getMessage();
        }
        return hostName;
    }

    public static int getValidIBANLength(String countryCode) {
        String code = countryCode.substring(0, 2).toUpperCase();
        String length = null;
        try {
            length = ResourceBundle.getBundle(UDF.class.getCanonicalName()).getString("length." + code);
        }
        catch (Exception e) {
            return -1;
        }
        if (length == null) {
            return -1;
        }
        return Integer.valueOf(length);
    }

    private static BigInteger getNumericIBAN(String iban, boolean isCheckDigitAtEnd) {
        String endCheckDigitIBAN = iban;
        if (!isCheckDigitAtEnd) {
            endCheckDigitIBAN = iban.substring(4) + iban.substring(0, 4);
        }
        StringBuffer numericIBAN = new StringBuffer();
        for (int i = 0; i < endCheckDigitIBAN.length(); ++i) {
            if (Character.isDigit(endCheckDigitIBAN.charAt(i))) {
                numericIBAN.append(endCheckDigitIBAN.charAt(i));
                continue;
            }
            numericIBAN.append(10 + UDF.getAlphabetPosition(endCheckDigitIBAN.charAt(i)));
        }
        return new BigInteger(numericIBAN.toString());
    }

    private static int getAlphabetPosition(char letter) {
        return Character.valueOf(Character.toUpperCase(letter)).compareTo(Character.valueOf('A'));
    }

    public static String getSHA256(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return "Unexpected getSHA256 error: " + ex.getMessage();
        }
    }

    public static String getEncodedUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception ex) {
            return "Unexpected URL encoding error: " + ex.getMessage();
        }
    }
}

